system_prompt ="""You are an Intent Evaluator. Your task is to compare an Original Prompt and a Perturbed Prompt to determine if they share the same core intent. Output a boolean value:
- True if the core intent or main goal is preserved.
- False if the core intent or main goal is substantially altered.

Guidelines:
1. Focus on the underlying purpose or objective of the prompt, not on exact wording.
2. Treat the intents as similar if they aim for the same general outcome, even if phrasing or style differs.
3. Disregard stylistic changes, rephrasing, or minor details as long as the core intent remains intact.
4. If the perturbed prompt introduces negations or command modifiers (e.g., "stop", "not") that are not present in the original, output False.
5. Check for abnormal repetitions: if the perturbed prompt unnecessarily repeats a word (e.g., "word word word") compared to the original, output False.
6. If you can reasonably argue that the prompts would lead to similar outcomes, output True; only output False when the goals or topics are clearly different.

Examples:
- Original: "Write a story about a lost dog finding home."  
  Perturbed: "Compose a tale about a pet’s journey back to its family."  
  Output: True

- Original: "Explain gravity to a child."  
  Perturbed: "Describe Earth’s pull on objects simply."  
  Output: True

- Original: "List cake ingredients."  
  Perturbed: "Explain the chemistry of cake baking."  
  Output: False

Remember: Your decision should strictly depend on whether the core intent of the prompt is preserved.
"""

import openai
import os

class Judge:
    def __init__(self):
        self.prompts = {
            'sys': {"role": "system", "content":system_prompt},
            'usr': {"role": "user", "content": "Original Prompt:\n{original}\nPerturbed Prompt:\n{perturbed}\nOutput:"}}
        self.model = 'gpt-4o-mini'
        self._load_api_key()



    def _load_api_key(self):
        # 1) Try environment variable
        self.api_key = os.getenv("OPENAI_API_KEY")

        # 2) Fallback to file if not in env
        if not self.api_key:
            try:
                with open('./openai_api_key.key', 'r') as f:
                    self.api_key = f.read().strip()
            except FileNotFoundError:
                raise RuntimeError(
                    "OpenAI API key not found. "
                    "Please set the OPENAI_API_KEY env var or create './openai_api_key.key'."
                )

        # 3) Instantiate client
        self.client = openai.OpenAI(api_key=self.api_key)

    def relabel(self, original, perurbed):
        user_prompt = self.prompts['usr']['content'].format(original=original, perturbed=perurbed)
        messages = [self.prompts['sys'], {"role": "user", "content": user_prompt}]
        #print(messages)

        response = self.client.chat.completions.create(
            model=self.model,
            messages=messages,
            temperature=0,
            max_tokens=512,
            seed=42,
            frequency_penalty=1
        )

        response_message = response.choices[0].message.content

        return response_message
